* This file does the primary analysis of the WVS in the appendices

*** Appendix A table
use "Processed files\WVS", clear
global range 10
range z -$range $range 10000
gen fz=normalden(z)
gen zfz=z*fz

foreach v of varlist hap sat {
	gen val_`v'=.
	gen low_`v'=.
	gen up_`v'=.
	gen fz_`v'=.
	tab `v'
	local steps=r(r)	
	xi: oprobit `v' i.ctywve [pw=wt]
	predict `v'_hat if `v'~=., xb
	summ `v'_hat [w=wt]
	local mn=r(mean)
	foreach i of numlist 1/`steps' {
		local j=`i'-1
		if `i'==1 {
			local lower=-$range
			local upper=_b[/cut1]
		}
		else if `i'==`steps' {
			local lower=_b[/cut`j']
			local upper=$range
		}
		else {
			local lower=_b[/cut`j']
			local upper=_b[/cut`i']
		}
		local lower=`lower'-`mn'
		local upper=`upper'-`mn'
		integ fz z if z<`upper' & z>`lower'
		local fz=r(integral)
		integ zfz z if z<`upper' & z>`lower'
		local zfz=r(integral)
		local m=`zfz'/`fz'
		di("Value `i' ranges from `lower' to `upper' and has mean ==`m'")
		replace val_`v'=`m' if `v'==`i'
		replace low_`v'=`lower' if `v'==`i'
		replace up_`v'=`upper' if `v'==`i'
		replace fz_`v'=`fz' if `v'==`i'
	}
	summ `v' [w=wt]
	gen z_`v'=(`v'-r(mean))/r(sd)
	table `v', c(m z_`v' m val_`v') format(%9.2f)
}


*** Appendix Figure A.1
egen t_hap=tag(hap)
cap drop point02 prop ez
gen point02=.02
gen str10 prop=string(fz_hap*100, "%2.1f")+"%"
gen str20 ez="E[z|category]"+string(val_hap, "%3.2f")
gen zero=0

foreach i of numlist 2 3 4 {
	summ low_hap if hap==`i'
	local j`i'=r(mean)
	local lows `lows' `j`i''
}
di("`lows'")
local mid1=(-3+`j2')/2
local mid2=(`j2'+`j3')/2
local mid3=(`j3'+`j4')/2
local mid4=(`j4'+3)/2
foreach i of numlist 1/4 {
	summ fz_hap if hap==`i'
	local fz`i'=string(r(mean)*100,"%4.1f")
	summ val_hap if hap==`i'
	local ez`i'=string(r(mean), "%4.2f")
}
#delimit ;
twoway
	(line fz z, sort lcolor(navy) )
	if abs(z)<3 
,
	xline(`lows', lcolor(black) lpattern(dash) lwidth(vthin))
	xtitle("Subjective well-being, z~N(0,1)")
	xlabel(-3(1)3)
	ytitle("Density f(z)")
	ylabel(0(.1).4, angle(horizontal))
	ytick(0(.1).5)
	text(.46 `mid1' "Not at all happy" "(`fz1'%)" "E[z|Not happy]" "=-1.46", size(small) justification(center) color(black))
	text(.46 `mid2' "Not very happy" "(`fz2'%)" "E[z|Not very happy]" "=-0.313", size(small) justification(center) color(black))
	text(.46 `mid3' "Quite happy" "(`fz3'%)" "E[z|Quite happy]" "=0.839", size(small) justification(center) color(black))
	text(.46 `mid4'  "Very happy" "(`fz4'%)" "E[z|Very happy]" "=2.256", size(small) justificatio(center) color(black))

	legend(off)
	xsize(10) ysize(7.5)
	name(figA1, replace)
;
#delimit cr
graph save "Figures/figA1.gph", replace

*** Appendix Figure A.2

egen t_satsw=tag(sat) if val_sat~=.
rename val_sat wvssat_sw
gen wvssat_x=sat
summ sat [aw=wt]
gen wvssat_std=(wvssat_x-r(mean))/r(sd)

egen t_hapsw=tag(hap)
rename val_hap wvshap_sw
gen wvshap_x=hap
summ sat [aw=wt]
gen wvshap_std=(wvshap_x-r(mean))/r(sd)

gen gwp_x=_n-1
replace gwp_x=. if gwp_x>10
gen gwp_sw=.
for X in num 0/10 \ Y in num -2.65 -2.06 -1.65 -1.2 -.75 -.17 .39 .83 1.36 1.88 2.46: replace gwp_sw=Y if gwp_x==X
gen t_gwpsw=gwp_x~=.
gen gwp_std=(gwp_x-5.4)/2


#delimit ;
twoway
	(scatter wvshap_sw wvshap_x if t_hapsw==1, mcolor(navy))
	(lfit wvshap_std wvshap_x if t_hapsw==1, lwidth(vvthin) lpattern(dash) lcolor(navy))
	(scatter wvssat_sw wvssat_x if t_satsw==1, msymbol(square) mcolor(green))
	(lfit wvssat_std wvssat_x if t_satsw==1, lwidth(vvthin) lpattern(dash) lcolor(green))
	(scatter gwp_sw gwp_x if t_gwpsw==1, msymbol(triangle) mcolor(cranberry))
	(line gwp_std gwp_x if t_gwpsw==1, lwidth(vvthin) lpattern(dash) lcolor(cranberry))

,
	xlabel(0(1)10)
	xtitle("Ordinal well-being categories")
	ytitle("Cardinal values: Stevenson-Wolfers ordered probit index")
	ylabel(-3(1)3, angle(horizontal))
	legend(
		order(1 "Happiness (World Values Survey)" 3 "Life Satisfaction (World Values Survey)" 5 "Satisfaction ladder (Gallup World Poll)")
		rows(3) pos(12) ring(0)
		region(fcolor(none))
	)
	xsize(10) ysize(7.5)
	name(figA2, replace)
;
#delimit cr
graph save "Figures/figA2.gph", replace

*** Figure A.4: Happiness
use "Processed files\WVS", clear
egen tag=tag(ctywve)

cap program drop labgraph
program define labgraph
	syntax varlist [if]
	marksample touse
	correl `1' `2' `if'
	global rho=string(r(rho),"%4.3f")
	reg `1' `2' `if'
	global b=string(_b[`2'],"%3.2f")
	global a=string(_b[_cons],"%3.2f")
	global se=string(_se[`2'],"%3.2f")
end

* Generate ordered probit indices
xi: oprobit hap i.ctywve [pw=wt] 
predict hap_hat if hap~=., xb
tomode hap_hat, by(ctywve) replace
summ hap_hat if tag==1
replace hap_hat=hap_hat-r(mean)

* Simple mean
xi: reg hap i.ctywve [pw=wt] 
predict hap_hat_simple if hap~=.
tomode hap_hat_simple, by(ctywve) replace
lowess hap_hat_simple hap_hat if tag==1, nograph generate(hap_hat_simple_low)
labgraph hap_hat_simple hap_hat if tag==1
#delimit ;
twoway 
	(scatter hap_hat_simple hap_hat, mcolor(navy)) 
	(line hap_hat_simple_low hap_hat, sort lpattern(dot) lcolor(cranberry))
	(lfit hap_hat_simple hap_hat, sort lpattern(longdash) lcolor(black))
	if tag==1
,
	title("Simple mean (1-4 response)", ring(0))
	xtitle("")
	ytitle("")
	xlabel(-1.5(.5)1.5, format(%4.1f))
	ylabel(2(.5)4 2 " 2.0", angle(horizontal) format(%4.1f))
	legend(off)
	note("y = $a+$b*x [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(meanh, replace)
;
#delimit cr

* Ordered logit
xi: ologit hap i.ctywve [pw=wt]
predict hap_hat_logit if hap~=., xb
tomode hap_hat_logit, by(ctywve) replace
summ hap_hat_logit if tag==1
replace hap_hat_logit=hap_hat_logit-r(mean)
lowess hap_hat_logit hap_hat if tag==1, nograph generate(hap_hat_logit_low)
labgraph hap_hat_logit hap_hat if tag==1

#delimit ;
twoway 
	(scatter hap_hat_logit hap_hat, mcolor(navy))
	(line hap_hat_logit_low hap_hat, sort lpattern(dot) lcolor(cranberry))
	(lfit hap_hat_logit hap_hat, sort lpattern(longdash) lcolor(black))
	if tag==1
,
	title("Ordered logit index", ring(0))
	xtitle("")
	ytitle("")
	xlabel(-1.5(.5)1.5, format(%4.1f))
	ylabel(-2(1)2 2 "   2", angle(horizontal))
	legend(off)
	note("y = $a+$b*x [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(ologith, replace)
;
#delimit cr

gen vhap=100*(hap>=3) if hap~=.
xi: reg vhap i.ctywve [pw=wt]
predict vhap_hat
tomode vhap_hat, by(ctywve) replace
lowess vhap_hat hap_hat if tag==1, nograph generate(vhap_hat_low)
labgraph vhap_hat hap_hat if tag==1
reg vhap_hat hap_hat if tag==1
predict vhap_hat_hat
#delimit ;
twoway 
	(scatter vhap_hat hap_hat, mcolor(navy))
	(line vhap_hat_low hap_hat, sort lpattern(dot) lcolor(cranberry))
	(line vhap_hat_hat hap_hat if vhap_hat_hat<100, sort lpattern(longdash) lcolor(black))
	if tag==1
,
	title("Percent quite or very happy", ring(0))
	xtitle("")
	ytitle("")
	xlabel(-1.5(.5)1.5, format(%4.1f))
	ytick(110, notick)
	ylabel(0(20)100, angle(horizontal))
	legend(off)
	note("y = $a+$b*x [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(vhap, replace)
;
#delimit cr


cap program drop  myoprobit1to4
program define myoprobit1to4
	version 6
	args lnf theta sd c1 c2 c3 
	local c0=-9999999
	local c4=9999999
	quietly replace `lnf'=ln(normprob((`theta'-`c0')/exp(`sd'))-normprob((`theta'-`c1')/exp(`sd'))) if $ML_y1==1
	quietly replace `lnf'=ln(normprob((`theta'-`c1')/exp(`sd'))-normprob((`theta'-`c2')/exp(`sd'))) if $ML_y1==2
	quietly replace `lnf'=ln(normprob((`theta'-`c2')/exp(`sd'))-normprob((`theta'-`c3')/exp(`sd'))) if $ML_y1==3
	quietly replace `lnf'=ln(normprob((`theta'-`c3')/exp(`sd'))-normprob((`theta'-`c4')/exp(`sd'))) if $ML_y1==4
end

egen ctywve3=group(ctywve) if hap~=.
xi i.ctywve3

ml model lf myoprobit1to4 (hap=_I*, noconst) (hap=_I*, noconst) /c1 /c2 /c3 [pw=wt]
local initmu
local initsd
foreach v of varlist _I* {
	local initmu `initmu' 0
	local initsd `initsd' 0
}
ml init `initmu' `initsd' 1 2 3 , copy
ml max

gen hap_oprobit_mu=.
gen hap_oprobit_sd=.
gen hap_oprobit_mu_se=.
gen hap_oprobit_sd_se=.

qui foreach v of varlist _I* {
	replace hap_oprobit_mu=[eq1]_b[`v'] if `v'==1
	replace hap_oprobit_mu_se=[eq1]_se[`v'] if `v'==1
	replace hap_oprobit_sd=exp([eq2]_b[`v']) if `v'==1
	replace hap_oprobit_sd_se=[eq2]_se[`v'] if `v'==1 /* This needs to be fixed */
}
for X in var hap_oprobit_mu hap_oprobit_mu_se hap_oprobit_sd hap_oprobit_sd_se: tomode X, by(ctywve) replace
summ hap_oprobit_mu if tag==1
replace hap_oprobit_mu=hap_oprobit_mu-r(mean)
reg hap_oprobit_mu lgdp if tag==1
reg hap_oprobit_sd lgdp if tag==1

lowess hap_oprobit_mu hap_hat if tag==1, nograph generate(hap_simple_mu_low)
labgraph hap_simple_mu hap_hat if tag==1 
#delimit ;
twoway 
	(scatter hap_oprobit_mu hap_hat, mcolor(navy))
	(line hap_simple_mu_low hap_hat, sort lpattern(dot) lcolor(cranberry))
	(lfit hap_simple_mu hap_hat, sort lpattern(longdash) lcolor(black))
	if tag==1
,
	title("Heteroscedastic ordered probit index", ring(0))
	xtitle("")
	ytitle("")
	xlabel(-1.5(.5)1.5, format(%4.1f))
	ylabel(-1.5(.5)2, format(%4.1f) angle(horizontal))
	legend(off)
	note("y = $a+$b*x [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(hoprobith, replace)
;
#delimit cr

#delimit ;
graph combine
	meanh ologith vhap hoprobith,
	xcommon
	b1title("Happiness: ordered probit index", size(small))
	rows(2)
	imargin(zero)
	xsize(10) ysize(7.5)
	name(figA4, replace)
;
#delimit cr
graph save "Figures\figA4", replace


*** Figure A.5: Satisfaction

* Generate ordered probit indices
xi: oprobit sat i.ctywve [pw=wt] 
predict sat_hat if sat~=., xb
tomode sat_hat, by(ctywve) replace
summ sat_hat if tag==1
replace sat_hat=sat_hat-r(mean)

* Simple mean
xi: reg sat i.ctywve [pw=wt]
predict sat_hat_simple if sat~=.
tomode sat_hat_simple, by(ctywve) replace
lowess sat_hat_simple sat_hat if tag==1, nograph generate(sat_hat_simple_low)
labgraph sat_hat_simple sat_hat if tag==1
#delimit ;
twoway 
	(scatter sat_hat_simple sat_hat, mcolor(navy))
	(line sat_hat_simple_low sat_hat, sort lpattern(dot) lcolor(cranberry))
	(lfit sat_hat_simple sat_hat, sort lpattern(longdash) lcolor(black))
	if tag==1
,
	title("Simple mean (1-10 response)", ring(0))
	xtitle("")
	ytitle("")
	xlabel(-1.5(.5)1.5, format(%4.1f))
	ylabel(3(1)9 3 "    3", angle(horizontal))
	legend(off)
	note("y = $a+$b*x [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(means, replace)
;
#delimit cr

xi: ologit sat i.ctywve [pw=wt]
predict sat_hat_logit if sat~=., xb
tomode sat_hat_logit, by(ctywve) replace
summ sat_hat_logit if tag==1
replace sat_hat_log=sat_hat_logit-r(mean)
lowess sat_hat_logit sat_hat if tag==1, nograph generate(sat_hat_logit_low)
labgraph sat_hat_logit sat_hat if tag==1
#delimit ;
twoway 
	(scatter sat_hat_logit sat_hat, mcolor(navy))
	(line sat_hat_logit_low sat_hat, sort lpattern(dot) lcolor(cranberry))
	(lfit sat_hat_logit sat_hat, sort lpattern(longdash) lcolor(black))
	if tag==1
,
	title("Ordered logit index", ring(0))
	xtitle("")
	ytitle("")
	xlabel(-1.5(.5)1.5, format(%4.1f))
	ylabel(-3(1)2, angle(horizontal))
	legend(off)
	note("y = $a+$b*x [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(ologits, replace)
;
#delimit cr

gen vsat=100*(sat>7) if sat~=.
xi: reg vsat i.ctywve [pw=wt]
predict vsat_hat
tomode vsat_hat, by(ctywve) replace
lowess vsat_hat sat_hat if tag==1, nograph generate(vsat_hat_low)
labgraph sat_hat_logit sat_hat if tag==1
#delimit ;
twoway 
	(scatter vsat_hat sat_hat, mcolor(navy))
	(line vsat_hat_low sat_hat, sort lpattern(dot) lcolor(cranberry))
	(lfit vsat_hat sat_hat, sort lpattern(longdash) lcolor(black))
	if tag==1
,
	title("Percent reporting satisfaction > 7", ring(0))
	xtitle("")
	ytitle("")
	xlabel(-1.5(.5)1.5, format(%4.1f))
	ylabel(0(20)100, angle(horizontal))
	legend(off)
	note("y = $a+$b*x [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(vsat, replace)
;
#delimit cr


cap program drop  myoprobit1to10
program define myoprobit1to10
	version 6
	args lnf theta sd c1 c2 c3 c4 c5 c6 c7 c8 c9 
	local c0=-9999999
	local c10=9999999
	quietly replace `lnf'=ln(normprob((`theta'-`c0')/exp(`sd'))-normprob((`theta'-`c1')/exp(`sd'))) if $ML_y1==1
	quietly replace `lnf'=ln(normprob((`theta'-`c1')/exp(`sd'))-normprob((`theta'-`c2')/exp(`sd'))) if $ML_y1==2
	quietly replace `lnf'=ln(normprob((`theta'-`c2')/exp(`sd'))-normprob((`theta'-`c3')/exp(`sd'))) if $ML_y1==3
	quietly replace `lnf'=ln(normprob((`theta'-`c3')/exp(`sd'))-normprob((`theta'-`c4')/exp(`sd'))) if $ML_y1==4
	quietly replace `lnf'=ln(normprob((`theta'-`c4')/exp(`sd'))-normprob((`theta'-`c5')/exp(`sd'))) if $ML_y1==5
	quietly replace `lnf'=ln(normprob((`theta'-`c5')/exp(`sd'))-normprob((`theta'-`c6')/exp(`sd'))) if $ML_y1==6
	quietly replace `lnf'=ln(normprob((`theta'-`c6')/exp(`sd'))-normprob((`theta'-`c7')/exp(`sd'))) if $ML_y1==7
	quietly replace `lnf'=ln(normprob((`theta'-`c7')/exp(`sd'))-normprob((`theta'-`c8')/exp(`sd'))) if $ML_y1==8
	quietly replace `lnf'=ln(normprob((`theta'-`c8')/exp(`sd'))-normprob((`theta'-`c9')/exp(`sd'))) if $ML_y1==9
	quietly replace `lnf'=ln(normprob((`theta'-`c9')/exp(`sd'))-normprob((`theta'-`c10')/exp(`sd'))) if $ML_y1==10

end

egen ctywve2=group(ctywve) if sat~=.
xi i.ctywve2
ml model lf myoprobit1to10 (sat=_I*, noconst) (sat=_I*, noconst) /c1 /c2 /c3 /c4 /c5 /c6 /c7 /c8 /c9 [pw=wt]
local initmu
local initsd
foreach v of varlist _I* {
	local initmu `initmu' 0
	local initsd `initsd' 0
}
ml init `initmu' `initsd' 1 2 3 4 5 6 7 8 9, copy
ml max

gen sat_oprobit_mu=.
gen sat_oprobit_sd=.
gen sat_oprobit_mu_se=.
gen sat_oprobit_sd_se=.


qui foreach v of varlist _I* {
	replace sat_oprobit_mu=[eq1]_b[`v'] if `v'==1
	replace sat_oprobit_mu_se=[eq1]_se[`v'] if `v'==1
	replace sat_oprobit_sd=exp([eq2]_b[`v']) if `v'==1
	replace sat_oprobit_sd_se=[eq2]_se[`v'] if `v'==1 /* This needs to be fixed */
}
for X in var sat_oprobit_mu sat_oprobit_mu_se sat_oprobit_sd sat_oprobit_sd_se: tomode X, by(ctywve) replace


summ sat_oprobit_mu if tag==1
replace sat_oprobit_mu=sat_oprobit_mu-r(mean)
lowess sat_oprobit_mu sat_hat if tag==1, nograph generate(sat_oprobit_mu_low)
labgraph sat_oprobit_mu sat_hat if tag==1
#delimit ;
twoway 
	(scatter sat_oprobit_mu sat_hat, mcolor(navy))
	(line sat_oprobit_mu_low sat_hat, sort lpattern(dot) lcolor(cranberry))
	(lfit sat_oprobit_mu sat_hat, sort lpattern(longdash) lcolor(black))
	if tag==1
,
	title("Heteroscedastic ordered probit index", ring(0))
	xtitle("")
	ytitle("")
	xlabel(-1.5(.5)1.5, format(%4.1f))
	ylabel(-2(1)2, angle(horizontal))
	legend(off)
	note("y = $a+$b*x [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(hoprobits, replace)
;
#delimit cr


#delimit ;
graph combine
	means ologits vsat hoprobits,
	xcommon
	b1title("Life satisfaction: ordered probit index", size(small))
	rows(2)
	imargin(tiny)
	xsize(10) ysize(7.5)
	name(figA5, replace)
;
#delimit cr
graph save "Figures\figA5", replace

*** Appendix B tables: Effects of non-representative countries

** Macro data first
*** Appendix table: Effect of representativeness
* Table 1-appendix
use "Processed files\WVS_macro", clear
* All countries
bys wave: reg sat_hat lgdp, robust
xi: reg sat_hat lgdp i.wave, robust cluster(cty)
bys wave: reg hap_hat lgdp, robust
xi: reg hap_hat lgdp i.wave, robust cluster(cty)
* Rich countries
bys wave: reg sat_hat lgdp if gdp>15000, robust
xi: reg sat_hat lgdp i.wave if gdp>15000, robust cluster(cty)
bys wave: reg hap_hat lgdp if gdp>15000, robust
xi: reg hap_hat lgdp i.wave if gdp>15000, robust cluster(cty)
* Poor countries
bys wave: reg sat_hat lgdp if gdp<15000, robust
xi: reg sat_hat lgdp i.wave if gdp<15000, robust cluster(cty)
bys wave: reg hap_hat lgdp if gdp<15000, robust
xi: reg hap_hat lgdp i.wave if gdp<15000, robust cluster(cty)

* Table 3-appendix
use "Processed files\WVS_macro", clear
egen cty_id=group(cty)

reg sat_hat lgdp, robust cluster(cty)
xi: reg sat_hat lgdp i.cty, robust cluster(cty) 
xi: reg sat_hat lgdp i.cty i.wave, robust cluster(cty)
egen t_sat=rank(wave) if lgdp~=. & sat_hat~=., by(cty)
tsset cty_id t_sat
reg d.sat_hat d.lgdp if t_sat~=., robust cluster(cty)
egen minwv_sat=min(wave) if lgdp~=. & sat_hat~=., by(cty)
egen maxwv_sat=max(wave) if lgdp~=. & sat_hat~=., by(cty)
egen d_sat=rank(t_sat) if (wave==minwv_sat | wave==maxwv_sat) & (minwv~=maxwv), by(cty)
tsset cty_id d_sat
reg d.sat_hat d.lgdp if d_sat~=., robust cluster(cty)
drop t_sat d_sat minwv maxwv

reg hap_hat lgdp, robust cluster(cty)
xi: reg hap_hat lgdp i.cty , robust cluster(cty)
xi: reg hap_hat lgdp i.cty i.wave, robust cluster(cty)
egen t_hap=rank(wave) if lgdp~=. & hap_hat~=., by(cty)
tsset cty_id t_hap
reg d.hap_hat d.lgdp if t_hap~=., robust cluster(cty)
egen minwv_hap=min(wave) if lgdp~=. & hap_hat~=., by(cty)
egen maxwv_hap=max(wave) if lgdp~=. & hap_hat~=., by(cty)
egen d_hap=rank(t_hap) if (wave==minwv_hap| wave==maxwv_hap) & (minwv~=maxwv), by(cty)
tsset cty_id d_hap
reg d.hap_hat d.lgdp if d_hap~=., robust cluster(cty)
drop t_hap d_hap minwv maxwv


** Micro data
* Table 1-Appendix B
use "Processed files\WVS", clear

* No controls
bys wave: oprobit sat lgdp [pw=wt1000], robust cluster(cty)
xi: oprobit sat lgdp i.wave [pw=wt1000], robust cluster(cty)
xi: oprobit sat lgdp i.wave [pw=wt1000] if nonrepresentative==0, robust cluster(cty)
bys wave: oprobit hap lgdp [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp i.wave [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp i.wave [pw=wt1000] if nonrepresentative==0, cluster(cty)

* With controls
bys wave: oprobit sat lgdp $controls [pw=wt1000], robust cluster(cty)
xi: oprobit sat lgdp $controls i.wave [pw=wt1000], robust cluster(cty)
xi: oprobit sat lgdp $controls i.wave [pw=wt1000] if nonrepresentative==0, robust cluster(cty)
bys wave: oprobit hap lgdp $controls [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp $controls i.wave [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp $controls i.wave [pw=wt1000] if nonrepresentative==0, cluster(cty)

* Table 2-Appendix B
use "Processed files\WVS" , clear
gen educ=x025
drop cty
gen cty=s003a /* Household income is consistently coded by i.s003a*i.wave, not by cty*/
egen ctywave=group(cty wave)
xi i.cty, prefix(c_) 
xi i.cty*i.wave, prefix(cw_) 

* No controls
bys wave: oprobit sat lninc c_* [pw=wt1000], robust nolog
oprobit sat lninc cw_* [pw=wt1000], robust nolog

bys wave: oprobit hap lninc c_* [pw=wt1000], robust nolog
oprobit hap lninc cw_* [pw=wt1000], robust nolog

* Controls
bys wave: oprobit sat lninc $controls c_* [pw=wt1000], robust nolog
oprobit sat lninc $controls cw_* [pw=wt1000], robust nolog

bys wave: oprobit hap lninc $controls c_* [pw=wt1000], robust nolog
oprobit hap lninc $controls cw_* [pw=wt1000], robust nolog


* IV
levelsof wave if educ~=., local(waves)
foreach w of local waves  {
	xi: reg lninc i.cty*i.educ $controls [pw=wt1000] if wave==`w' & sat~=.
	predict lninc_hat if lninc~=. & educ~=. & cty~=. & sat~=. & wave==`w' 
	predict lninc_res if lninc~=. & educ~=. & cty~=. & sat~=. & wave==`w', res	
	xi: oprobit sat lninc_hat lninc_res $controls i.cty if wave==`w' [pw=wt1000], robust nolog
	drop lninc_hat lninc_res
}
xi: reg lninc  i.educ*i.ctywave $controls [pw=wt1000] if sat~=.
predict lninc_hat if lninc~=. & educ~=. & cty~=. & sat~=.
predict lninc_res if lninc~=. & educ~=. & cty~=. & sat~=. , res	
xi: oprobit sat lninc_hat lninc_res $controls i.ctywave [pw=wt1000], robust nolog
drop lninc_hat lninc_res

levelsof wave if educ~=., local(waves)
foreach w of local waves {
	xi: reg lninc i.cty*i.educ $controls [pw=wt1000] if wave==`w' & hap~=.
	predict lninc_hat if lninc~=. & educ~=. & cty~=. & hap~=. & wave==`w'
	predict lninc_res if lninc~=. & educ~=. & cty~=. & hap~=. & wave==`w', res	
	xi: oprobit hap lninc_hat lninc_res $controls i.cty if wave==`w' [pw=wt1000], robust nolog
	drop lninc_hat lninc_res
}
xi: reg lninc  i.educ*i.ctywave $controls [pw=wt1000] if hap~=.
predict lninc_hat if lninc~=. & educ~=. & cty~=. & hap~=. 
predict lninc_res if lninc~=. & educ~=. & cty~=. & hap~=. , res	
xi: oprobit hap lninc_hat lninc_res $controls i.ctywave [pw=wt1000], robust nolog
drop lninc_hat lninc_res

* Table 3-appendix B
use "Processed files\WVS", clear
oprobit sat  lgdp [pw=wt1000], cluster(cty)
xi: oprobit sat lgdp i.cty [pw=wt1000], cluster(cty)
xi: oprobit sat lgdp i.cty i.wave [pw=wt1000], cluster(cty)
egen minwv_sat=min(wave) if sat~=. & lgdp~=., by(cty)
egen maxwv_sat=max(wave) if sat~=. & lgdp~=., by(cty)
xi: oprobit sat lgdp i.cty i.wave if (wave==minwv | wave==maxwv) & (maxwv~=minwv) [pw=wt1000], cluster(cty)
drop minwv maxwv

oprobit hap  lgdp [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp i.cty [pw=wt1000], cluster(cty)
xi: oprobit hap lgdp i.cty i.wave [pw=wt1000], cluster(cty)
egen minwv_hap=min(wave) if hap~=. & lgdp~=., by(cty)
egen maxwv_hap=max(wave) if hap~=. & lgdp~=., by(cty)
xi: oprobit hap lgdp i.cty i.wave if (wave==minwv | wave==maxwv) & (maxwv~=minwv) [pw=wt1000], cluster(cty)
drop minwv maxwv

